#include <algorithm>
#include <bits/stdc++.h>
using namespace std;

const int MAXN = 11;

int cijene[MAXN][MAXN];
map<string, int> drzava_map, proizvod_map;
vector<int> drzave;

void obradi(const string &linija) {
  int l = linija.size();
  int i = 0;
  string ime;
  for (; linija[i] != '-'; i++) {
    ime += linija[i];
  }
  i++;
  string drzava;
  for (; linija[i] != '-'; i++) {
    drzava += linija[i];
  }
  i++;
  int cijena = 0;
  for (; i < l; i++) {
    if (linija[i] >= '0' && linija[i] <= '9') {
      cijena *= 10;
      cijena += linija[i] - '0';
    }
  }
  if (!drzava_map.count(drzava)) {
    drzava_map[drzava] = drzava_map.size();
  }
  if (!proizvod_map.count(ime)) {
    proizvod_map[ime] = proizvod_map.size();
  }
  cijene[proizvod_map[ime]][drzava_map[drzava]] = cijena;
}

int main() {
  memset(cijene, -1, sizeof cijene);
  int n;
  cin >> n;
  for (int i = 0; i < n; i++) {
    string linija;
    cin >> linija;
    obradi(linija);
  }

  pair<int, int> best = {-1, -1};
  drzave.resize(max(drzava_map.size(), proizvod_map.size()));
  iota(drzave.begin(), drzave.end(), 0);

  do {
    pair<int, int> tmp = {0, 0};
    for (int i = 0; i < (int)drzave.size(); i++) {
      if (cijene[i][drzave[i]] != -1) {
        tmp.first++;
        tmp.second -= cijene[i][drzave[i]];
      }
    }
    best = max(best, tmp);
  } while (next_permutation(drzave.begin(), drzave.end()));

  cout << best.first << " " << -best.second / 100 << ",";
  int ostatak = (-best.second) % 100;
  if (ostatak < 10) {
    cout << "0";
  }
  cout << ostatak << endl;

  return 0;
}
